#Cuadro IX.4
#Anlisis de covarianza.

##############################################
#Seccin modificable por el usuario
##############################################

#Lectura de datos.
datos<-read.csv2("Cuadro IX.3.V.csv",header=TRUE,encoding="latin1")

#Seleccin variable dependiente. En caso de que se deseen utilizar valores transformados, desmarcamos la transformacin que nos interese como "NULL".
varInteres<-c("Longitud.anal")
#varInteres<-c("Dimetro.ojo")

#Seleccin de un tipo de transformacin para las variables de inters. Si no se transforma la variable debe mantenerse la opcin "NULL".
varInteres1X2<-NULL
varInteres1X<-NULL
varInteresLN<-NULL
varInteresLOG10<-NULL
varInteresSQR<-NULL
varInteresX2<-NULL
varInteresX3<-NULL
varInteresEX<-NULL
varInteresASN<-NULL

#varInteres1X2<-c(1,1)
#varInteres1X<-c(1,1)
#varInteresLN<-c(1,1)
#varInteresLOG10<-c(1,1)
#varInteresSQR<-c(1,1)
#varInteresX2<-c(1,1)
#varInteresX3<-c(1,1)
#varInteresEX<-c(1,1)
#varInteresASN<-c(1,1)

#Variables que corresponden al factor.
Factor1<-c("Especie")
Factor2<-c("Investigador")
#Factor2<-NULL
Factor3<-c("Zona")
#Factor3<-NULL

#Variables que corresponden a la covariable
Covariable1<-c("Longitud.total")
Covariable2<-c("Dimetro.ojo")
Covariable2<-NULL
Covariable3<-c("Base.anal")
Covariable3<-NULL
Covariable4<-c("")
Covariable4<-NULL

#Covariable para la regresin lineal y la grfica
Covregr1<-c("Longitud.total")
#Covregr1<-NULL
Covregr2<-c("Dimetro.ojo")
Covregr2<-NULL
Covregr3<-c("Base.anal")
Covregr3<-NULL
Covregr4<-c("")
Covregr4<-NULL

#Transformar covariables logartmicamente
#1.Transformar covariable 1
#2.Transformar covariable 2
#3.Transformar covariable 3
#4.Transformar covariable 4

transcov<-c(1,2)
transcov<-c(0)

#Variables de seleccin.
#varSeleccion1<-list(c("",""))
varSeleccion1<-NULL
#varSeleccion2<-list(c("","",""))
varSeleccion2<-NULL

#Tipo de suma de cuadrados
#SS<-c(2)
SS<-c(3)

#Archivo de salida.
ArchivodeSalida<-"Salida Cuadro IX.4.txt"

###############################################
#Seccin que realiza el procedimiento
###############################################

#paquetes
require(lawstat)
require(e1071)
require(car)
require(nortest)
require(multcomp)

##Organizacin de los datos.
valores<-(datos[,varInteres])
if (length(varInteres1X2)==2) valores<-1/((datos[,varInteres])^2)
if (length(varInteres1X)==2) valores<-1/(datos[,varInteres])
if (length(varInteresLN)==2) valores<-log(datos[,varInteres])
if (length(varInteresLOG10)==2) valores<-log10(datos[,varInteres])
if (length(varInteresSQR)==2) valores<-sqrt((datos[,varInteres]))
if (length(varInteresX2)==2) valores<-(datos[,varInteres])^2
if (length(varInteresX3)==2) valores<-(datos[,varInteres])^3
if (length(varInteresEX)==2) valores<-exp(datos[,varInteres])
if (length(varInteresASN)==2) valores<-asin((datos[,varInteres]))

#Factores
factores<-data.frame(datos[,c(Factor1,Factor2,Factor3)])
if (ncol(factores)==1) names(factores)<-c("Factor1")
if (ncol(factores)==2) names(factores)<-c("Factor1","Factor2")
if (ncol(factores)==3) names(factores)<-c("Factor1","Factor2","Factor3")
if (ncol(factores)==1) F1<-as.factor(factores[,"Factor1"])
if (ncol(factores)==2) {F1<-as.factor(factores[,"Factor1"])
                        F2<-as.factor(factores[,"Factor2"])
}
if (ncol(factores)==3) {F1<-as.factor(factores[,"Factor1"])
                        F2<-as.factor(factores[,"Factor2"])
                        F3<-as.factor(factores[,"Factor3"])
}

if (ncol(factores)==1) factores2<-data.frame(F1)
if (ncol(factores)==2) factores2<-data.frame(F1,F2)
if (ncol(factores)==3) factores2<-data.frame(F1,F2,F3)

#Covariables
covariables<-data.frame(datos[,c(Covariable1,Covariable2,Covariable3,Covariable4)])
if (ncol(covariables)==1) names(covariables)<-c("Cov1")
if (ncol(covariables)==2) names(covariables)<-c("Cov1","Cov2")
if (ncol(covariables)==3) names(covariables)<-c("Cov1","Cov2","Cov3")
if (ncol(covariables)==4) names(covariables)<-c("Cov1","Cov2","Cov3","Cov4")
if (ncol(covariables)==1) C1<-data.frame(covariables[,"Cov1"])
if (ncol(covariables)==2){C1<-data.frame(covariables[,"Cov1"])
                          C2<-data.frame(covariables[,"Cov2"])
}
if (ncol(covariables)==3){C1<-data.frame(covariables[,"Cov1"])
                          C2<-data.frame(covariables[,"Cov2"])
                          C3<-data.frame(covariables[,"Cov3"])
}
if (ncol(covariables)==4){C1<-data.frame(covariables[,"Cov1"])
                          C2<-data.frame(covariables[,"Cov2"])
                          C3<-data.frame(covariables[,"Cov3"])
                          C4<-data.frame(covariables[,"Cov4"])
}

if (ncol(covariables)==1) {covariables2<-data.frame(C1)
                           names(covariables2)<-c("C1")
}
if (ncol(covariables)==2) {covariables2<-data.frame(C1,C2)
                           names(covariables2)<-c("C1","C2")
}
if (ncol(covariables)==3) {covariables2<-data.frame(C1,C2,C3)
                           names(covariables2)<-c("C1","C2","C3")
}
if (ncol(covariables)==4) {covariables2<-data.frame(C1,C2,C3,C4)
                           names(covariables2)<-c("C1","C2","C3","C4")
}

if (transcov!=0) for (i in transcov){
                   if (i==1) covariables2[,"C1"]<-log(covariables2[,"C1"])
                   if (i==2) covariables2[,"C2"]<-log(covariables2[,"C2"])
                   if (i==3) covariables2[,"C3"]<-log(covariables2[,"C3"])
                   if (i==4) covariables2[,"C4"]<-log(covariables2[,"C4"])
}

#Seleccion
if (length(varSeleccion1)!=0){
 w1<-data.frame(row.names=1:dim(datos)[1])
 varBin1<-as.character()
 for (i in 1:length(varSeleccion1)){
   nom1<-varSeleccion1[[i]][1]
   x1<-factor(datos[,nom1])
   if (length(varSeleccion1[[i]])>1){
      sufijo1<-paste(varSeleccion1[[i]][2:3],collapse="_")
      nom1<-paste(nom1,".",sufijo1,sep="")
      x11<-factor(ifelse(x1 %in% varSeleccion1[[i]][2:3],as.character(x1),NA))
      x11<-data.frame(factor(x11))
   }else{
      x11<-x1
      x11<-data.frame(x1)
   }
   names(x11)<-nom1
   varBin1<-c(varBin1,nom1)
   w1<-data.frame(w1,x11)
 }
}

if (length(varSeleccion2)!=0){
 w2<-data.frame(row.names=1:dim(datos)[1])
 varBin2<-as.character()
 for (i in 1:length(varSeleccion2)){
   nom2<-varSeleccion2[[i]][1]
   x2<-factor(datos[,nom2])
   if (length(varSeleccion2[[i]])>1){
      sufijo2<-paste(varSeleccion2[[i]][2:3],collapse="_")
      nom2<-paste(nom2,".",sufijo2,sep="")
      x12<-factor(ifelse(x2 %in% varSeleccion2[[i]][2:3],as.character(x2),NA))
      x12<-data.frame(factor(x12))
   }else{
      x12<-x2
      x12<-data.frame(x2)
   }
   names(x12)<-nom2
   varBin2<-c(varBin2,nom2)
   w2<-data.frame(w2,x12)
 }
}

if ((length(varSeleccion1)!=0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w1,w2)
if ((length(varSeleccion1)!=0)&(length(varSeleccion2)==0)) seleccion<-data.frame(w1)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w2)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)==0)) seleccion<-NULL

#Conjunto de datos
if (length(seleccion)==0) datos2<-data.frame(valores,covariables2,factores2)
if (length(seleccion)!=0) datos2<-data.frame(seleccion,valores,covariables2,factores2)
datos2<-na.omit(datos2)

#Modelo lineal univariante y extraccin de resduos.
options(contrasts=c("contr.sum", "contr.poly"))
if ((ncol(factores)==1)&(ncol(covariables)==1)) modelo<-lm(datos2$valores~datos2$C1+datos2$F1)
if ((ncol(factores)==1)&(ncol(covariables)==2)) modelo<-lm(datos2$valores~datos2$C1+datos2$C2+datos2$F1)
if ((ncol(factores)==1)&(ncol(covariables)==3)) modelo<-lm(datos2$valores~datos2$C1+datos2$C2+datos2$C3+datos2$F1)
if ((ncol(factores)==1)&(ncol(covariables)==4)) modelo<-lm(datos2$valores~datos2$C1+datos2$C2+datos2$C3+datos2$C4+datos2$F1)

if ((ncol(factores)==2)&(ncol(covariables)==1)) modelo<-lm(datos2$valores~datos2$C1+datos2$F1*datos2$F2)
if ((ncol(factores)==2)&(ncol(covariables)==2)) modelo<-lm(datos2$valores~datos2$C1+datos2$C2+datos2$F1*datos2$F2)
if ((ncol(factores)==2)&(ncol(covariables)==3)) modelo<-lm(datos2$valores~datos2$C1+datos2$C2+datos2$C3+datos2$F1*datos2$F2)
if ((ncol(factores)==2)&(ncol(covariables)==4)) modelo<-lm(datos2$valores~datos2$C1+datos2$C2+datos2$C3+datos2$C4+datos2$F1*datos2$F2)

if ((ncol(factores)==3)&(ncol(covariables)==1)) modelo<-lm(datos2$valores~datos2$C1+datos2$F1*datos2$F2*datos2$F3)
if ((ncol(factores)==3)&(ncol(covariables)==2)) modelo<-lm(datos2$valores~datos2$C1+datos2$C2+datos2$F1*datos2$F2*datos2$F3)
if ((ncol(factores)==3)&(ncol(covariables)==3)) modelo<-lm(datos2$valores~datos2$C1+datos2$C2+datos2$C3+datos2$F1*datos2$F2*datos2$F3)
if ((ncol(factores)==3)&(ncol(covariables)==4)) modelo<-lm(datos2$valores~datos2$C1+datos2$C2+datos2$C3+datos2$C4+datos2$F1*datos2$F2*datos2$F3)

Resumenmodelo1<-Anova(modelo,type=SS)
Resumenmodelo2<-summary.lm(modelo)

residuos<-residuals(modelo)
datos3<-data.frame(residuos,datos2)

Factores<-c("Factores empleados en el anlisis:",list(Factor1,Factor2,Factor3))
Covariables<-c("Covariables empleadas en el anlisis:",list(Covariable1,Covariable2,Covariable3,Covariable4))

#prueba de normalidad en los resduos.
PruebaNormLillie<-lillie.test(residuos)
PruebaNormShapiro<-shapiro.test(residuos)

#Prueba de heterocedasticidad en los resduos.
if (ncol(factores)==1) {PruebaHetF1M<-levene.test(datos3$residuos,datos3$F1)
                        PruebaHetF2M<-NULL
                        PruebaHetF3M<-NULL
}
if (ncol(factores)==2) {PruebaHetF1M<-levene.test(datos3$residuos,datos3$F1)
                        PruebaHetF2M<-levene.test(datos3$residuos,datos3$F2)
                        PruebaHetF3M<-NULL
}
if (ncol(factores)==3) {PruebaHetF1M<-levene.test(datos3$residuos,datos3$F1)
                        PruebaHetF2M<-levene.test(datos3$residuos,datos3$F2)
                        PruebaHetF3M<-levene.test(datos3$residuos,datos3$F3)
}


PruebaHet<-list("Factor1",PruebaHetF1M,"Factor2",PruebaHetF2M,"Factor3",PruebaHetF3M)

#Sesgo.
Sesgodatos<-c("Sesgo",skewness(datos3$residuos,type=2))
Curtosisdatos<-c("Curtosis",kurtosis(datos3$residuos,type=2))

#Funciones Grficas y modelos de regresin para la relacin entre la variable dependiente y las covariables.

Grafica1<-function(datos){
                        plot(datos[,Covregr1],valores,pch=16,col="blue")
                        abline(lm(valores~datos[,Covregr1]),lty=1,col="blue")
                        }
Grafica2<-function(datos){
                        plot(datos[,Covregr2],valores,pch=16,col="red")
                        abline(lm(valores~datos[,Covregr2]),lty=1,col="red")
                        }
Grafica3<-function(datos){
                        plot(datos[,Covregr3],valores,pch=16,col="green")
                        abline(lm(valores~datos[,Covregr3]),lty=1,col="green")
                        }
Grafica4<-function(datos){
                        plot(datos[,Covregr4],valores,pch=16,col="black")
                        abline(lm(valores~datos[,Covregr4]),lty=1,col="black")
                        }

if (transcov!=0) for (i in transcov){
                   if (i==1) datos[,Covregr1]<-log(datos[,Covregr1])
                   if (i==2) datos[,Covregr2]<-log(datos[,Covregr2])
                   if (i==3) datos[,Covregr3]<-log(datos[,Covregr3])
                   if (i==4) datos[,Covregr4]<-log(datos[,Covregr4])
}

if(length(Covregr1)!=0){
lineal1<-lm(valores~datos[,Covregr1])
Reslineal1<-summary(lineal1)
}
if(length(Covregr2)!=0){
lineal2<-lm(valores~datos[,Covregr2])
Reslineal2<-summary(lineal2)
}
if(length(Covregr3)!=0){
lineal3<-lm(valores~datos[,Covregr3])
Reslineal3<-summary(lineal3)
}
if(length(Covregr4)!=0){
lineal4<-lm(valores~datos[,Covregr4])
Reslineal4<-summary(lineal4)
}
###############################################
#Seccin que muestra los resultados
###############################################

#Lista de resultados
Resultados<-list("ANCOVA",Factores,Covariables,Resumenmodelo1,Resumenmodelo2,PruebaNormLillie,PruebaNormShapiro,PruebaHet,Sesgodatos,Curtosisdatos)

#Grficos
if(length(Covregr1)!=0){
Grafica1(datos)
}
if(length(Covregr2)!=0){
x11()
Grafica2(datos)
}
par(ask=FALSE)
if(length(Covregr3)!=0){
x11()
Grafica3(datos)
}
par(ask=FALSE)
if(length(Covregr4)!=0){
x11()
Grafica4(datos)
}
par(ask=FALSE)

#Archivo de salida
if(!is.null(ArchivodeSalida)){
 sink(ArchivodeSalida)
 print(Resultados)
 if(length(Covregr1)!=0)print(Reslineal1)
 if(length(Covregr2)!=0)print(Reslineal2)
 if(length(Covregr3)!=0)print(Reslineal3)
 if(length(Covregr4)!=0)print(Reslineal4)
 sink()
}
